#include "AudioStack/SMT/clSrcState_On.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{


void clSrcState_On::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 )
{
  if (NULL != pclAudioSource)
   {
      pclAudioSource->vNotifyOnDone();
   }
}

void clSrcState_On::vMsg_On(clAudioSource* pclAudioSource, tU32 )
{
   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (NULL != pclAudioSource &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_On();
   }
}

void clSrcState_On::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData);
}

void clSrcState_On::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData);
}

void clSrcState_On::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // begin sequence again with init, because the play event was lost
    vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampUpInit(), u32UserData);
}

}//namespace
